<?php

require_once '../model/database.php';
require_once '../model/product_model.php';
require_once '../model/vendor_model.php';  
require_once 'header.php';

$vendors = get_all_vendors($conn);  // Fetch all vendors for the dropdown
$errors = [];
$inputData = [
    'prod_id' => '',
    'prod_name' => '',
    'prod_price' => '',
    'prod_desc' => '',
    'vend_id' => ''
];

echo "<h1>Add New Product</h1>";
echo "<nav><a href='../index.php'>Home</a> | <a href='product_info.php'>Product Info</a> | <a href='manage_vendors.php'>Vendors</a></nav>";

if (isset($_POST['add'])) {
    $inputData = [
        'prod_id' => trim($_POST['prod_id']),
        'prod_name' => trim($_POST['prod_name']),
        'prod_price' => trim($_POST['prod_price']),
        'prod_desc' => trim($_POST['prod_desc']),
        'vend_id' => trim($_POST['vend_id']),
    ];

    // Validate product ID (Example: must be numeric and not empty)
    if (empty($inputData['prod_id'])) {
        $errors['prod_id'] = "Product ID is required.";
    } elseif (!is_numeric($inputData['prod_id'])) {
        $errors['prod_id'] = "Product ID must be numeric.";
    } else {
        if (product_exists($conn, $inputData['prod_id'])) {
            $errors['prod_id'] = "Product ID already exists.";
        }
    }

    // Validate product name
    if (empty($inputData['prod_name'])) {
        $errors['prod_name'] = "Product Name is required.";
    } elseif (strlen($inputData['prod_name']) > 255) {
        $errors['prod_name'] = "Product Name cannot exceed 255 characters.";
    }

    // Validate product price
    if (empty($inputData['prod_price'])) {
        $errors['prod_price'] = "Product Price is required.";
    } elseif (!is_numeric($inputData['prod_price'])) {
        $errors['prod_price'] = "Product Price must be numeric.";
    }

    // Validate product description
    if (empty($inputData['prod_desc'])) {
        $errors['prod_desc'] = "Product Description is required.";
    }

    // Add the product if there are no validation errors
    if (empty($errors) && isset($_POST['add'])) {
        add_product($conn, $inputData['prod_id'], $inputData['prod_name'], $inputData['prod_price'], $inputData['prod_desc'], $inputData['vend_id']);
        echo "<p>Product added successfully.</p>";
    }
}

?>

<form method="post">
    <label>Product ID: <input type="text" name="prod_id" value="<?php echo htmlspecialchars($inputData['prod_id']); ?>">
        <?php if (isset($errors['prod_id'])) echo "<span class='error-msg'>" . $errors['prod_id'] . "</span>"; ?>
    </label><br>

    <label>Product Name: <input type="text" name="prod_name" value="<?php echo htmlspecialchars($inputData['prod_name']); ?>">
        <?php if (isset($errors['prod_name'])) echo "<span class='error-msg'>" . $errors['prod_name'] . "</span>"; ?>
    </label><br>

    <label>Product Price: <input type="number" step="0.01" name="prod_price" value="<?php echo htmlspecialchars($inputData['prod_price']); ?>">
        <?php if (isset($errors['prod_price'])) echo "<span class='error-msg'>" . $errors['prod_price'] . "</span>"; ?>
    </label><br>

    <label>Product Description: <textarea name="prod_desc"><?php echo htmlspecialchars($inputData['prod_desc']); ?></textarea>
        <?php if (isset($errors['prod_desc'])) echo "<span class='error-msg'>" . $errors['prod_desc'] . "</span>"; ?>
    </label><br>

    <label>Vendor:
        <select name="vend_id">
            <?php foreach ($vendors as $vendor) { ?>
                <option value="<?php echo $vendor['vend_id']; ?>" <?php if ($vendor['vend_id'] == $inputData['vend_id']) echo 'selected'; ?>><?php echo $vendor['vend_name']; ?></option>
            <?php } ?>
        </select>
        <?php if (isset($errors['vend_id'])) echo "<span class='error-msg'>" . $errors['vend_id'] . "</span>"; ?>
    </label><br>

    <input type="submit" name="add" value="Add Product">
</form>

<?php

require_once 'footer.php';

?>
